require "TimedActions/ISBaseTimedAction"

TABAS_AddBathSalt = ISBaseTimedAction:derive("TABAS_AddBathSalt")

function TABAS_AddBathSalt:isValid()
    if isClient() and self.item then
	    return self.character:getInventory():containsID(self.item:getID())
	else
	    return self.character:getInventory():contains(self.item)
	end
end

function TABAS_AddBathSalt:waitToStart()
    if self.character:isAiming() then
        self.character:nullifyAiming()
    end
    if self.character:isSneaking() then
        self.character:setSneaking(false)
    end
    self.character:faceThisObject(self.tfc_Base.bathObject)
    return self.character:shouldBeTurning()
end

function TABAS_AddBathSalt:update()
    self.item:setJobDelta(self:getJobDelta())
end

function TABAS_AddBathSalt:start()
    if isClient() and self.item then
        self.item = self.character:getInventory():getItemById(self.item:getID())
    end

    self.item:setJobDelta(0.0)
    self:setActionAnim("Pour")
    self:setOverrideHandModels(self.item:getStaticModel(), nil)
    self.sound = self.character:getEmitter():playSound("DropSoilFromSandBag")
end

function TABAS_AddBathSalt:stopSound()
    if self.sound and self.character:getEmitter():isPlaying(self.sound) then
        self.character:stopOrTriggerSound(self.sound)
    end
end

function TABAS_AddBathSalt:stop()
    if self.item then
        self.item:setJobDelta(0.0)
    end
    self:stopSound()
	ISBaseTimedAction.stop(self)
end

function TABAS_AddBathSalt:complete()
    self.item:UseAndSync()
    self.tfc_Base:addBathSalt(self.def)
    return true
end

function TABAS_AddBathSalt:perform()
    self:stopSound()
    if self.item then
        self.item:setJobDelta(0.0)
    end

	-- needed to remove from queue / start next.
	ISBaseTimedAction.perform(self)
end

function TABAS_AddBathSalt:adjustMaxTime(maxTime)
    return maxTime
end

function TABAS_AddBathSalt:new(character, tfc_Base, def, item)
    local o = ISBaseTimedAction.new(self, character)
    o.tfc_Base = tfc_Base
    -- o.object = tfc_Base.bathObject
    o.item = item
    o.def = def
    o.maxTime = 160

    o.ignoreHandsWounds = true
    o.useProgressBar = true
    o.caloriesModifier = 0
    return o
end